/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.commands;

import com.blamejared.crafttweaker.api.data.StringConverter;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.impl.brackets.BracketHandlers;
import com.google.common.collect.Lists;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openzen.zenscript.lexer.ParseException;

public enum CTItemArgument implements ArgumentType<IItemStack>
{
    INSTANCE;

    private static final Collection<String> EXAMPLES;
    private static final DynamicCommandExceptionType MALFORMED_DATA;
    private static final SimpleCommandExceptionType INVALID_STRING;
    private static final Pattern ITEM_PATTERN;

    public IItemStack parse(StringReader reader) throws CommandSyntaxException {
        Matcher matcher = ITEM_PATTERN.matcher(reader.getRemaining());
        if (!matcher.find()) {
            throw INVALID_STRING.createWithContext((ImmutableStringReader)reader);
        }
        String itemLocation = matcher.group(1);
        try {
            IItemStack stack = CTItemArgument.getItem(itemLocation, matcher.group(3));
            reader.setCursor(reader.getCursor() + matcher.group(0).length());
            return stack;
        }
        catch (ParseException e) {
            reader.setCursor(reader.getCursor() + itemLocation.length() + "<item:>.withTag(".length() + e.position.getFromLineOffset());
            throw MALFORMED_DATA.createWithContext((ImmutableStringReader)reader, (Object)e);
        }
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    private static IItemStack getItem(String location, String tag) throws ParseException {
        IItemStack stack = BracketHandlers.getItem(location).mutable();
        if (tag != null) {
            stack.withTag(StringConverter.convert(tag));
        }
        return stack;
    }

    static {
        EXAMPLES = Lists.newArrayList((Object[])new String[]{"<item:minecraft:apple>", "<item:minecraft:iron_ingot>.withTag({display: {Name: \"wow\" as string}})"});
        MALFORMED_DATA = new DynamicCommandExceptionType(o -> new LiteralMessage(((ParseException)o).message));
        INVALID_STRING = new SimpleCommandExceptionType((Message)new LiteralMessage("invalid string"));
        ITEM_PATTERN = Pattern.compile("<item:(\\w+:\\w+)>(.withTag\\((\\{.*})\\))?");
    }
}

